	function [G, Z, P] = IMPULSE_INVARIANT(G, Z, P, T)
 
	%	Computes the poles and zeros for an impulse response-invariant 
	%	filter from an analog lowpass filter. 
	%	T is the sample period. The impulse response have been multiplied 
	%	with T in order to obtain suitable passband gain.
	%	The band edge for a digital lowpass filter is approximately 
	%	wcT which should be << pi in order to not have too large aliasing.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2010-09-10
	% 	Modified by: 	LW2010-11-02, LW2017-11-08, LW 2018-03-28	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	N = length(P);
	t_axis = [0:T:2*N*T];
	[h, dirac0, t_axis] = PZ_2_IMPULSE_RESPONSE_S(G, Z, P, t_axis);
	P = exp(P.*T);
	denum = ROOTS_2_POLY(P);
	h(1) = dirac0
	Hn = toeplitz(h(1:N+1), [h(1) zeros(1, N)]);
 	numer = Hn*denum'	
	Z = roots(numer);	 
	G = real(prod(1-P)/real(prod(1-Z)));
